package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;param&gt;</code> element</strong> defines parameters for an <a title="The HTML <object> element represents an external resource, which can be treated as an image, a nested browsing context, or a resource to be handled by a plugin." href="/en-US/docs/Web/HTML/Element/object"><code>&lt;object&gt;</code></a> element.
 */
object param extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Param
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("param", mods)
}


}

object _param_attr {

}
