package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * A regular expression that the control's value is checked against. The pattern must match the entire value, not just some subset. Use the <strong>title</strong> attribute to describe the pattern to help the user. This attribute applies when the value of the <strong>type</strong> attribute is <code>text</code>, <code>search</code>, <code>tel</code>, <code>url</code>, <code>email</code>, or <code>password</code>,&nbsp;otherwise it is ignored. The regular expression language is the same as JavaScript <a title="The RegExp constructor creates a regular expression object for matching text with a pattern." href="/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp"><code>RegExp</code></a> algorithm, with the <code>'u'</code> parameter that makes it treat the pattern as a sequence of unicode code points. The pattern is not surrounded by forward slashes.
 */
object pattern extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_pattern_attr.type]("pattern", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_pattern_attr.type]("pattern", v)
type attrType = _pattern_attr.type

}

object _pattern_attr {
@inline implicit def toinputApplied(pair: AttrPair[_pattern_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_pattern_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_pattern_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_pattern_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
