package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * textarea - A hint to the user of what can be entered in the control. Carriage returns or line-feeds within the placeholder text must be treated as line breaks when rendering the hint.
 * input - A hint to the user of what can be entered in the control . The placeholder text must not contain carriage returns or line-feeds.&nbsp; <div class="note"> <strong>Note:</strong> Do not use the  <code>placeholder</code> attribute instead of a  <a title="The HTML <label> element represents a caption for an item in a user interface." href="/en-US/docs/Web/HTML/Element/label"><code>&lt;label&gt;</code></a> element, their purposes are different. The  <a title="The HTML <label> element represents a caption for an item in a user interface." href="/en-US/docs/Web/HTML/Element/label"><code>&lt;label&gt;</code></a> attribute describes the role of the form element (i.e.&nbsp;it indicates what kind of information is expected), and the  <code>placeholder</code> attribute is a hint about the format that the content should take. There are cases in which the  <code>placeholder</code> attribute is never displayed to the user, so the form must be understandable without it.</div>
 */
object placeholder extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_placeholder_attr.type]("placeholder", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_placeholder_attr.type]("placeholder", v)
type attrType = _placeholder_attr.type

}

object _placeholder_attr {
@inline implicit def toinputApplied(pair: AttrPair[_placeholder_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_placeholder_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def totextareaApplied(pair: AttrPair[_placeholder_attr.type]) = pair.asInstanceOf[AttrPair[textarea.tag.type]]
@inline implicit def totextareaOptionalApplied(pair: OptionalAttrPair[_placeholder_attr.type]) = pair.asInstanceOf[OptionalAttrPair[textarea.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_placeholder_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_placeholder_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
