package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * A URL indicating a poster frame to show until the user plays or seeks. If this attribute isn't specified, nothing is displayed until the first frame is available; then the first frame is shown as the poster frame.
 */
object poster extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_poster_attr.type]("poster", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_poster_attr.type]("poster", v)
type attrType = _poster_attr.type

}

object _poster_attr {
@inline implicit def tovideoApplied(pair: AttrPair[_poster_attr.type]) = pair.asInstanceOf[AttrPair[video.tag.type]]
@inline implicit def tovideoOptionalApplied(pair: OptionalAttrPair[_poster_attr.type]) = pair.asInstanceOf[OptionalAttrPair[video.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_poster_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_poster_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
