package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;pre&gt;</code> element</strong> represents preformatted text. Text within this element is typically displayed in a non-proportional ("<a href="/en-US/docs/XUL/Style/monospace">monospace</a>") font exactly as it is laid out in the file. Whitespace inside this element is displayed as typed.
 */
object pre extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Pre
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("pre", mods)
}


}

object _pre_attr {

}
