package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * audio - This enumerated attribute is intended to provide a hint to the browser about what the author thinks will lead to the best user experience. It may have one of the following values: <ul>  <li><code>none</code>: indicates that the audio should not be preloaded;</li>  <li><code>metadata</code>: indicates that only audio metadata (e.g. length) is fetched;</li>  <li><code>auto</code>: indicates that the whole audio file could be downloaded, even if the user is not expected to use it;</li>  <li>the <em>empty string</em>: synonym of the <code>auto</code> value.</li> </ul> <p>If not set, its default value is browser-defined (i.e. each browser may have its own default value). The spec advises it to be set to <code>metadata</code>.</p> <div class="note"> <strong>Usage notes:</strong>  <ul>   <li>The <code>autoplay</code> attribute has precedence over&nbsp;<code>preload</code>. If <code>autoplay</code> is specified, the browser would obviously need to start downloading the audio for playback.</li>   <li>The browser is not forced by the specification to follow the value of this attribute; it is a mere hint.</li>  </ul> </div>
 * video - This enumerated attribute is intended to provide a hint to the browser about what the author thinks will lead to the best user experience. It may have one of the following values: <ul>  <li><code>none</code>: indicates that the video should not be preloaded.</li>  <li><code>metadata</code>: indicates that only video metadata (e.g. length) is fetched.</li>  <li><code>auto</code>: indicates that the whole video file could be downloaded, even if the user is not expected to use it.</li>  <li>the <em>empty string</em>: synonym of the <code>auto</code> value.</li> </ul> <p>If not set, its default value is browser-defined (i.e. each browser may have its default value). The spec advises it to be set to <code>metadata</code>.</p> <div class="note"> <strong>Usage notes:</strong>  <ul>   <li>The <code>autoplay</code> attribute has precedence over <code>preload</code>. If <code>autoplay</code> is specified, the browser would obviously need to start downloading the video for playback.</li>   <li>The specification does not force the browser to follow the value of this attribute; it is a mere hint.</li>  </ul> </div>
 */
object preload extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_preload_attr.type]("preload", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_preload_attr.type]("preload", v)
type attrType = _preload_attr.type

}

object _preload_attr {
@inline implicit def toaudioApplied(pair: AttrPair[_preload_attr.type]) = pair.asInstanceOf[AttrPair[audio.tag.type]]
@inline implicit def toaudioOptionalApplied(pair: OptionalAttrPair[_preload_attr.type]) = pair.asInstanceOf[OptionalAttrPair[audio.tag.type]]
             
@inline implicit def tovideoApplied(pair: AttrPair[_preload_attr.type]) = pair.asInstanceOf[AttrPair[video.tag.type]]
@inline implicit def tovideoOptionalApplied(pair: OptionalAttrPair[_preload_attr.type]) = pair.asInstanceOf[OptionalAttrPair[video.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_preload_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_preload_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
