package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;progress&gt;</code> element</strong> represents the completion progress of a task, typically displayed as a progress bar.
 */
object progress extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Progress
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("progress", mods)
}


}

object _progress_attr {

}
