package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * area - For anchors containing the <strong>href</strong> attribute, this attribute specifies the relationship of the target object to the link object. The value is a comma-separated list of <a href="/en-US/docs/Web/HTML/Link_types">link types values</a>. The values and their semantics will be registered by some authority that might have meaning to the document author. The default relationship, if no other is given, is void. Use this attribute only if the <strong>href</strong> attribute is present.
 * link - This attribute names a relationship of the linked document to the current document. The attribute must be a space-separated list of the <a href="/en-US/docs/Web/HTML/Link_types">link types values</a>. The most common use of this attribute is to specify a link to an external style sheet: the <strong>rel</strong> attribute is set to <code>stylesheet</code>, and the <strong>href</strong> attribute is set to the URL of an external style sheet to format the page. WebTV also supports the use of the value <code>next</code> for <strong>rel</strong> to preload the next page in a document series.
 * a - Specifies the relationship of the target object to the link object. The value is a space-separated list of <a href="/en-US/docs/Web/HTML/Link_types">link types</a>.
 */
object rel extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_rel_attr.type]("rel", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_rel_attr.type]("rel", v)
type attrType = _rel_attr.type

}

object _rel_attr {
@inline implicit def toaApplied(pair: AttrPair[_rel_attr.type]) = pair.asInstanceOf[AttrPair[a.tag.type]]
@inline implicit def toaOptionalApplied(pair: OptionalAttrPair[_rel_attr.type]) = pair.asInstanceOf[OptionalAttrPair[a.tag.type]]
             
@inline implicit def toareaApplied(pair: AttrPair[_rel_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_rel_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def tolinkApplied(pair: AttrPair[_rel_attr.type]) = pair.asInstanceOf[AttrPair[link.tag.type]]
@inline implicit def tolinkOptionalApplied(pair: OptionalAttrPair[_rel_attr.type]) = pair.asInstanceOf[OptionalAttrPair[link.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_rel_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_rel_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
