package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * textarea - This attribute specifies that the user must fill in a value before submitting a form.
 * select - A Boolean attribute indicating that an option with a non-empty string value must be selected.
 * input - This attribute specifies that the user must fill in a value before submitting a form. It cannot be used when the <strong>type</strong> attribute is <code>hidden</code>, <code>image</code>, or a button type (<code>submit</code>, <code>reset</code>, or <code>button</code>). The <a title="The :optional CSS pseudo-class represents any <input>, <select>, or <textarea> element that does not have the required attribute set on it." href="/en-US/docs/Web/CSS/:optional"><code>:optional</code></a> and <a title="The :required CSS pseudo-class represents any <input>, <select>, or <textarea>&nbsp;element that has the required attribute set on it." href="/en-US/docs/Web/CSS/:required"><code>:required</code></a> CSS pseudo-classes will be applied to the field as appropriate.
 */
object required extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_required_attr.type]("required", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_required_attr.type]("required", v)
type attrType = _required_attr.type
@inline implicit def boolToPairinputApplied(attrObj: this.type) = new AttrPair[input.tag.type]("required", true)
@inline implicit def boolToPairselectApplied(attrObj: this.type) = new AttrPair[select.tag.type]("required", true)
@inline implicit def boolToPairtextareaApplied(attrObj: this.type) = new AttrPair[textarea.tag.type]("required", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("required", true)
}

object _required_attr {
@inline implicit def toinputApplied(pair: AttrPair[_required_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_required_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def toselectApplied(pair: AttrPair[_required_attr.type]) = pair.asInstanceOf[AttrPair[select.tag.type]]
@inline implicit def toselectOptionalApplied(pair: OptionalAttrPair[_required_attr.type]) = pair.asInstanceOf[OptionalAttrPair[select.tag.type]]
             
@inline implicit def totextareaApplied(pair: AttrPair[_required_attr.type]) = pair.asInstanceOf[AttrPair[textarea.tag.type]]
@inline implicit def totextareaOptionalApplied(pair: OptionalAttrPair[_required_attr.type]) = pair.asInstanceOf[OptionalAttrPair[textarea.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_required_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_required_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
