package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * This Boolean attribute specifies that the items of the list are specified in reversed order.
 */
object reversed extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_reversed_attr.type]("reversed", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_reversed_attr.type]("reversed", v)
type attrType = _reversed_attr.type
@inline implicit def boolToPairolApplied(attrObj: this.type) = new AttrPair[ol.tag.type]("reversed", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("reversed", true)
}

object _reversed_attr {
@inline implicit def toolApplied(pair: AttrPair[_reversed_attr.type]) = pair.asInstanceOf[AttrPair[ol.tag.type]]
@inline implicit def toolOptionalApplied(pair: OptionalAttrPair[_reversed_attr.type]) = pair.asInstanceOf[OptionalAttrPair[ol.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_reversed_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_reversed_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
