package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * td - This attribute contains a positive integer indicating the number of consecutive rows the <code>&lt;td&gt;</code> element spans. If not present, its default value is <code>1</code>.
 * th - This attribute contains a positive integer indicating the number of consecutive rows the <code>&lt;th&gt;</code> element spans. If not present, its default value is <code>1</code>.
 */
object rowSpan extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Int) = new AttrPair[_rowSpan_attr.type]("rowSpan", v)
@inline def :=(v: Option[Int]) = new OptionalAttrPair[_rowSpan_attr.type]("rowSpan", v)
type attrType = _rowSpan_attr.type

}

object _rowSpan_attr {
@inline implicit def totdApplied(pair: AttrPair[_rowSpan_attr.type]) = pair.asInstanceOf[AttrPair[td.tag.type]]
@inline implicit def totdOptionalApplied(pair: OptionalAttrPair[_rowSpan_attr.type]) = pair.asInstanceOf[OptionalAttrPair[td.tag.type]]
             
@inline implicit def tothApplied(pair: AttrPair[_rowSpan_attr.type]) = pair.asInstanceOf[AttrPair[th.tag.type]]
@inline implicit def tothOptionalApplied(pair: OptionalAttrPair[_rowSpan_attr.type]) = pair.asInstanceOf[OptionalAttrPair[th.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_rowSpan_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_rowSpan_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
