package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;rt&gt;</code> element</strong> embraces pronunciation of characters presented in a ruby annotations, which are used to describe the pronunciation of East Asian characters. This element is always used inside a <a title="The HTML <ruby> element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters." href="/en-US/docs/Web/HTML/Element/ruby"><code>&lt;ruby&gt;</code></a> element.
 */
object rt extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Element
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("rt", mods)
}


}

object _rt_attr {

}
