package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * If specified as an empty string, this attribute enables extra restrictions on the content that can appear in the inline frame. The value of the attribute can either be an empty string (all the restrictions are applied), or a space-separated list of tokens that lift particular restrictions. Valid tokens are: <ul>  <li><code>allow-forms</code>: Allows the embedded browsing context to submit forms. If this keyword is not used, this operation is not allowed.</li>  <li><code>allow-modals</code>: Allows the embedded browsing context to open modal windows.</li>  <li><code>allow-orientation-lock</code>: Allows the embedded browsing context to disable the ability to lock the screen orientation.</li>  <li><code>allow-pointer-lock</code>: Allows the embedded browsing context to use the <a href="/en-US/docs/WebAPI/Pointer_Lock">Pointer Lock API</a>.</li>  <li><code>allow-popups</code>: Allows popups (like from <code>window.open</code>, <code>target="_blank"</code>, <code>showModalDialog</code>). If this keyword is not used, that functionality will silently fail.</li>  <li><code>allow-popups-to-escape-sandbox</code>:&nbsp; Allows a sandboxed document to open new windows without forcing the sandboxing flags upon them. This will allow, for example, a third-party advertisement to be safely sandboxed without forcing the same restrictions upon a landing page.</li>  <li><code>allow-presentation</code>: Allows embedders to have control over whether an iframe can start a presentation session.</li>  <li><code>allow-same-origin</code>: Allows the content to be treated as being from its normal origin. If this keyword is not used, the embedded content is treated as being from a unique origin.</li>  <li><code>allow-scripts</code>: Allows the embedded browsing context to run scripts (but not create pop-up windows). If this keyword is not used, this operation is not allowed.</li>  <li><code>allow-top-navigation</code>: Allows the embedded browsing context to navigate (load) content to the top-level browsing context. If this keyword is not used, this operation is not allowed.</li>  <li><code>allow-top-navigation-by-user-activation</code>: Allows the embedded browsing context to navigate (load) content to the top-level browsing context only when initiated by a user gesture. If this keyword is not used, this operation is not allowed.</li> </ul> <div class="note">  <p><strong>Note:</strong></p>  <ul>   <li>When the embedded document has the same origin as the main page, it is strongly discouraged to use both <code>allow-scripts</code> and <code>allow-same-origin</code> at the same time, as that allows the embedded document to programmatically remove the <code>sandbox</code> attribute. Although it is accepted, this case is no more secure than not using the <code>sandbox</code> attribute.</li>   <li>Sandboxing in general is only of minimal help if the attacker can arrange for the potentially hostile content to be displayed in the user's browser outside a sandboxed <code>iframe</code>. It is recommended that such content should be served from a <em>separate dedicated domain</em>, to limit the potential damage.</li>   <li>The <code>sandbox</code> attribute is not supported in Internet Explorer 9 and earlier versions.</li>  </ul> </div>
 */
object sandbox extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_sandbox_attr.type]("sandbox", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_sandbox_attr.type]("sandbox", v)
type attrType = _sandbox_attr.type

}

object _sandbox_attr {
@inline implicit def toiframeApplied(pair: AttrPair[_sandbox_attr.type]) = pair.asInstanceOf[AttrPair[iframe.tag.type]]
@inline implicit def toiframeOptionalApplied(pair: OptionalAttrPair[_sandbox_attr.type]) = pair.asInstanceOf[OptionalAttrPair[iframe.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_sandbox_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_sandbox_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
