package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * th - This enumerated attribute defines the cells that the header (defined in the <a title="The HTML <th> element defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes." href="/en-US/docs/Web/HTML/Element/th"><code>&lt;th&gt;</code></a>) element relates to. It may have the following values: <ul>  <li><code>row</code>:&nbsp; The header relates to all cells of the row it belongs to.</li>  <li><code>col</code>: The header relates to all cells of the column&nbsp;it belongs to.</li>  <li><code>rowgroup</code>: The header belongs to a rowgroup and relates to all of its cells. These cells can be placed to the right or the left of the header, depending on&nbsp;the value of the <code><a href="/en-US/docs/Web/HTML/Global_attributes/dir">dir</a></code> attribute in&nbsp;the <a title="The HTML <table> element represents tabular data — that is, information expressed via a two-dimensional data table." href="/en-US/docs/Web/HTML/Element/table"><code>&lt;table&gt;</code></a> element.</li>  <li><code>colgroup</code>: The header belongs to a colgroup and relates to all of its cells.</li>  <li><code>auto</code></li> </ul>
 * td - &nbsp;
 */
object scope extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_scope_attr.type]("scope", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_scope_attr.type]("scope", v)
type attrType = _scope_attr.type

}

object _scope_attr {
@inline implicit def totdApplied(pair: AttrPair[_scope_attr.type]) = pair.asInstanceOf[AttrPair[td.tag.type]]
@inline implicit def totdOptionalApplied(pair: OptionalAttrPair[_scope_attr.type]) = pair.asInstanceOf[OptionalAttrPair[td.tag.type]]
             
@inline implicit def tothApplied(pair: AttrPair[_scope_attr.type]) = pair.asInstanceOf[AttrPair[th.tag.type]]
@inline implicit def tothOptionalApplied(pair: OptionalAttrPair[_scope_attr.type]) = pair.asInstanceOf[OptionalAttrPair[th.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_scope_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_scope_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
