package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * Specifies that the styles only apply to this element's parent element and that element's child elements.
 */
object scoped extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_scoped_attr.type]("scoped", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_scoped_attr.type]("scoped", v)
type attrType = _scoped_attr.type
@inline implicit def boolToPairstyleApplied(attrObj: this.type) = new AttrPair[style.tag.type]("scoped", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("scoped", true)
}

object _scoped_attr {
@inline implicit def tostyleApplied(pair: AttrPair[_scoped_attr.type]) = pair.asInstanceOf[AttrPair[style.tag.type]]
@inline implicit def tostyleOptionalApplied(pair: OptionalAttrPair[_scoped_attr.type]) = pair.asInstanceOf[OptionalAttrPair[style.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_scoped_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_scoped_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
