package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;script&gt;</code> element</strong> is used to embed or reference an executable script.
 */
object script extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Script
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("script", mods)
}


}

object _script_attr {

}
