package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * Enumerated attribute indicating when the browser should provide a scroll bar (or other scrolling device) for the frame: <ul>  <li><code>auto</code>: Only when needed.</li>  <li><code>yes</code>: Always provide a scroll bar.</li>  <li><code>no</code>: Never provide a scroll bar.</li> </ul>
 */
object scrolling extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_scrolling_attr.type]("scrolling", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_scrolling_attr.type]("scrolling", v)
type attrType = _scrolling_attr.type

}

object _scrolling_attr {
@inline implicit def toiframeApplied(pair: AttrPair[_scrolling_attr.type]) = pair.asInstanceOf[AttrPair[iframe.tag.type]]
@inline implicit def toiframeOptionalApplied(pair: OptionalAttrPair[_scrolling_attr.type]) = pair.asInstanceOf[OptionalAttrPair[iframe.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_scrolling_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_scrolling_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
