package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * If present, this Boolean attribute indicates that the option is initially selected. If the <code>&lt;option&gt;</code> element is the descendant of a <a title="The HTML <select> element represents a control that provides a menu of options:" href="/en-US/docs/Web/HTML/Element/select"><code>&lt;select&gt;</code></a> element whose <code><a href="/en-US/docs/Web/HTML/Element/select#attr-multiple">multiple</a></code> attribute is not set, only one single <code>&lt;option&gt;</code> of this <a title="The HTML <select> element represents a control that provides a menu of options:" href="/en-US/docs/Web/HTML/Element/select"><code>&lt;select&gt;</code></a> element may have the <code>selected</code> attribute.
 */
object selected extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_selected_attr.type]("selected", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_selected_attr.type]("selected", v)
type attrType = _selected_attr.type
@inline implicit def boolToPairoptionApplied(attrObj: this.type) = new AttrPair[option.tag.type]("selected", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("selected", true)
}

object _selected_attr {
@inline implicit def tooptionApplied(pair: AttrPair[_selected_attr.type]) = pair.asInstanceOf[AttrPair[option.tag.type]]
@inline implicit def tooptionOptionalApplied(pair: OptionalAttrPair[_selected_attr.type]) = pair.asInstanceOf[OptionalAttrPair[option.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_selected_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_selected_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
