package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * a - This attribute was used to define a region for hyperlinks to create an image map. The values are <code>circle</code>, <code>default</code>, <code>polygon</code>, and <code>rect</code>. The format of the <strong>coords</strong> attribute depends on the value of shape. For <code>circle</code>, the value is <code>x,y,r</code> where <code>x</code> and <code>y</code> are the pixel coordinates for the center of the circle and <code>r</code> is the radius value in pixels. For <code>rect</code>, the <strong>coords</strong> attribute should be <code>x,y,w,h</code>. The <code>x,y</code> values define the upper-left-hand corner of the rectangle, while <code>w</code> and <code>h</code> define the width and height respectively. A value of <code>polygon</code> for <strong>shape</strong> requires <code>x1,y1,x2,y2,...</code> values for <strong>coords</strong>. Each of the <code>x,y</code> pairs defines a point in the polygon, with successive points being joined by straight lines and the last point joined to the first. The value <code>default</code> for shape requires that the entire enclosed area, typically an image, be used. <div class="note"> <strong>Note:</strong> Use the  <a href="/en-US/docs/Web/HTML/Element/img#attr-usemap"><code>usemap</code> attribute</a> for the  <a title="The HTML <img> element represents an image in the document." href="/en-US/docs/Web/HTML/Element/img"><code>&lt;img&gt;</code></a> element and the associated  <a title="The HTML <map> element is used with <area> elements to define an image map (a clickable link area)." href="/en-US/docs/Web/HTML/Element/map"><code>&lt;map&gt;</code></a> element to define hotspots instead of the  <code>shape</code> attribute.</div>
 * area - The shape of the associated hot spot. The specifications for HTML 5 and HTML 4 define the values <code>rect</code>, which defines a rectangular region; <code>circle</code>, which defines a circular region; <code>poly</code>, which defines a polygon; and <code>default</code>, which indicates the entire region beyond any defined shapes. Many browsers, notably Internet Explorer 4 and higher, support <code>circ</code>, <code>polygon</code>, and <code>rectangle</code> as valid values for <strong>shape</strong>; these values are <span title="This API has not been standardized."><i class="icon-warning-sign"> </i></span>.
 */
object shape extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_shape_attr.type]("shape", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_shape_attr.type]("shape", v)
type attrType = _shape_attr.type

}

object _shape_attr {
@inline implicit def toaApplied(pair: AttrPair[_shape_attr.type]) = pair.asInstanceOf[AttrPair[a.tag.type]]
@inline implicit def toaOptionalApplied(pair: OptionalAttrPair[_shape_attr.type]) = pair.asInstanceOf[OptionalAttrPair[a.tag.type]]
             
@inline implicit def toareaApplied(pair: AttrPair[_shape_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_shape_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_shape_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_shape_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
