package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * select - If the control is presented as a scrolled list box, this attribute represents the number of rows in the list that should be visible at one time. Browsers are not required to present a select element as a scrolled list box. The default value is 0.
 * input - The initial size of the control. This value is in pixels unless the value of the <strong>type</strong> attribute is <code>text</code> or <code>password</code>, in which case&nbsp;it is an integer number of characters. Starting in HTML5, this attribute applies only when the <strong>type</strong> attribute is set to <code>text</code>, <code>search</code>, <code>tel</code>, <code>url</code>, <code>email</code>, or <code>password</code>, otherwise it is ignored. In addition, the size must be greater than zero. If you do not specify a size, a default value of 20 is used. HTML5 simply states&nbsp;"the user agent should ensure that at least that many characters are visible", but different characters can have different widths in certain&nbsp;fonts.&nbsp;In some browsers, a certain string with <em>x</em> characters will not be entirely visible even if size is defined to at least <em>x</em>.
 * hr - Sets the height, in pixels, of the rule.
 */
object size extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_size_attr.type]("size", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_size_attr.type]("size", v)
type attrType = _size_attr.type

}

object _size_attr {
@inline implicit def tohrApplied(pair: AttrPair[_size_attr.type]) = pair.asInstanceOf[AttrPair[hr.tag.type]]
@inline implicit def tohrOptionalApplied(pair: OptionalAttrPair[_size_attr.type]) = pair.asInstanceOf[OptionalAttrPair[hr.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_size_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_size_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def toselectApplied(pair: AttrPair[_size_attr.type]) = pair.asInstanceOf[AttrPair[select.tag.type]]
@inline implicit def toselectOptionalApplied(pair: OptionalAttrPair[_size_attr.type]) = pair.asInstanceOf[OptionalAttrPair[select.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_size_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_size_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
