package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * img - A list of one or more strings separated by commas indicating a set of source sizes. Each source size consists of: <ol>  <li>a media condition. This must be omitted for the last item.</li>  <li>a source size value.</li> </ol> <p>Source size values specify the intended display size of the image. User agents use the current source size to select one of the sources supplied by the <code>srcset</code> attribute, when those sources are described using width ('<code>w</code>') descriptors. The selected source size affects the intrinsic size of the image (the image’s display size if no CSS styling is applied). If the <code>srcset</code> attribute is absent, or contains no values with a width (<code>w</code>) descriptor, then the <code>sizes</code> attribute has no effect.</p>
 * source - Is a list of source sizes that describes the final rendered width of the image represented by the source. Each source size consists of a comma-separated list of media condition-length pairs. This information is used by the browser to determine, before laying the page out, which image defined in <code><a href="/en-US/docs/Web/HTML/Element/source#attr-srcset">srcset</a></code> to use.<br> The <code>sizes</code> attribute has an effect only when the <a title="The HTML <source> element specifies multiple media resources for either the <picture>, the <audio> or the <video> element. It is an empty element. It is commonly used to serve the same media content in multiple formats supported by different browsers." href="/en-US/docs/Web/HTML/Element/source"><code>&lt;source&gt;</code></a> element is the direct child of a <a title="The HTML <picture> element is a container used to specify multiple <source> elements for a specific <img> contained in it. The browser will choose the most suitable source according to the current layout of the page (the constraints of the box the image will appear in) and the device it will be displayed on (e.g. a normal or hiDPI device.)" href="/en-US/docs/Web/HTML/Element/picture"><code>&lt;picture&gt;</code></a> element.
 * link - This attribute defines the sizes of the icons for visual media contained in the resource. It must be present only if the <code><a href="/en-US/docs/Web/HTML/Element/link#attr-rel">rel</a></code> contains the <code>icon</code> <a href="/en-US/docs/Web/HTML/Link_types">link types value</a>. It may have the following values: <ul>  <li><code>any</code>, meaning that the icon can be scaled to any size as it is in a vectorial format, like <code>image/svg+xml</code>.</li>  <li>a white-space separated list of sizes, each in the format <code><em>&lt;width in pixels&gt;</em>x<em>&lt;height in pixels&gt;</em></code> or <code><em>&lt;width in pixels&gt;</em>X<em>&lt;height in pixels&gt;</em></code>. Each of these sizes must be contained in the resource.</li> </ul> <div class="note"> <strong>Usage note: </strong>  <ul>   <li>Most icon format are only able to store one single icon; therefore most of the time the <code><a href="/en-US/docs/Web/HTML/Global_attributes#attr-sizes">sizes</a></code> contains only one entry. MS's ICO format does, as well as Apple's ICNS. ICO being more ubiquitous, you should use it.</li>   <li>Apple's iOS does not support this attribute, hence Apple's iPhone and iPad use special, non-standard <a href="/en-US/docs/Web/HTML/Link_types">link types values</a> to define icon to be used as Web Clip or start-up placeholder: <code>apple-touch-icon</code> and <code>apple-touch-startup-icon</code>.</li>  </ul> </div>
 */
object sizes extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_sizes_attr.type]("sizes", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_sizes_attr.type]("sizes", v)
type attrType = _sizes_attr.type

}

object _sizes_attr {
@inline implicit def toimgApplied(pair: AttrPair[_sizes_attr.type]) = pair.asInstanceOf[AttrPair[img.tag.type]]
@inline implicit def toimgOptionalApplied(pair: OptionalAttrPair[_sizes_attr.type]) = pair.asInstanceOf[OptionalAttrPair[img.tag.type]]
             
@inline implicit def tolinkApplied(pair: AttrPair[_sizes_attr.type]) = pair.asInstanceOf[AttrPair[link.tag.type]]
@inline implicit def tolinkOptionalApplied(pair: OptionalAttrPair[_sizes_attr.type]) = pair.asInstanceOf[OptionalAttrPair[link.tag.type]]
             
@inline implicit def tosourceApplied(pair: AttrPair[_sizes_attr.type]) = pair.asInstanceOf[AttrPair[source.tag.type]]
@inline implicit def tosourceOptionalApplied(pair: OptionalAttrPair[_sizes_attr.type]) = pair.asInstanceOf[OptionalAttrPair[source.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_sizes_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_sizes_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
