package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;source&gt;</code> element</strong> specifies multiple media resources for either the <a title="The HTML <picture> element is a container used to specify multiple <source> elements for a specific <img> contained in it. The browser will choose the most suitable source according to the current layout of the page (the constraints of the box the image will appear in) and the device it will be displayed on (e.g. a normal or hiDPI device.)" href="/en-US/docs/Web/HTML/Element/picture"><code>&lt;picture&gt;</code></a>, the <a title="The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element:&nbsp;the browser will choose the most suitable one. It can also be the destination for streamed media, using a MediaStream." href="/en-US/docs/Web/HTML/Element/audio"><code>&lt;audio&gt;</code></a> or the <a title="Use the HTML <video> element to embed video content in a document." href="/en-US/docs/Web/HTML/Element/video"><code>&lt;video&gt;</code></a> element. It is an empty element. It is commonly used to serve the same media content in <a href="/en-US/docs/Media_formats_supported_by_the_audio_and_video_elements">multiple formats supported by different browsers</a>.
 */
object source extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Source
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("source", mods)
}


}

object _source_attr {

}
