package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * <span class="seoSummary">The <strong>HTML <code>&lt;span&gt;</code> element</strong> is a generic inline container for phrasing content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the <code>class</code> or <code>id</code> attributes), or because they share attribute values, such as <code>lang</code>.</span> It should be used only when no other semantic element is appropriate. <code>&lt;span&gt;</code> is very much like a <a title="The HTML <div> element is the generic container for flow content and does not inherently represent anything. Use it to group elements for purposes such as styling (using the class or id attributes), marking a section of a document in a different language (using the lang attribute), and so on." href="/en-US/docs/Web/HTML/Element/div"><code>&lt;div&gt;</code></a> element, but <a title="The HTML <div> element is the generic container for flow content and does not inherently represent anything. Use it to group elements for purposes such as styling (using the class or id attributes), marking a section of a document in a different language (using the lang attribute), and so on." href="/en-US/docs/Web/HTML/Element/div"><code>&lt;div&gt;</code></a> is a <a href="/en-US/docs/HTML/Block-level_elements">block-level element</a> whereas a <code>&lt;span&gt;</code> is an<a href="/en-US/docs/HTML/Inline_elements"> inline element</a>.
 * col - This attribute contains a positive integer indicating the number of consecutive columns the <code>&lt;col&gt;</code> element spans. If not present, its default value is <code>1</code>.
 * colgroup - This attribute contains a positive integer indicating the number of consecutive columns the <code>&lt;colgroup&gt;</code> element spans. If not present, its default value is <code>1</code>. <div class="note"> <strong>Note: </strong>This attribute is applied on the attributes of the column group, it has no effect on the CSS styling rules associated with it or, even more, to the cells of the column's members of the group.  <ul>   <li>The <code>span</code> attribute may not be present if there are one or more <code>&lt;col&gt;</code> elements within the <code>&lt;colgroup&gt;</code>.</li>  </ul> </div>
 */
object span extends Tag with Attr {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Span
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("span", mods)
}
@inline def :=(v: Int) = new AttrPair[_span_attr.type]("span", v)
@inline def :=(v: Option[Int]) = new OptionalAttrPair[_span_attr.type]("span", v)
type attrType = _span_attr.type

}

object _span_attr {
@inline implicit def tocolApplied(pair: AttrPair[_span_attr.type]) = pair.asInstanceOf[AttrPair[col.tag.type]]
@inline implicit def tocolOptionalApplied(pair: OptionalAttrPair[_span_attr.type]) = pair.asInstanceOf[OptionalAttrPair[col.tag.type]]
             
@inline implicit def tocolgroupApplied(pair: AttrPair[_span_attr.type]) = pair.asInstanceOf[AttrPair[colgroup.tag.type]]
@inline implicit def tocolgroupOptionalApplied(pair: OptionalAttrPair[_span_attr.type]) = pair.asInstanceOf[OptionalAttrPair[colgroup.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_span_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_span_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
