package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * track - Address of the track (<code>.vtt</code> file). Must be a valid URL. This attribute must be defined.
 * source - Required for <a title="The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element:&nbsp;the browser will choose the most suitable one. It can also be the destination for streamed media, using a MediaStream." href="/en-US/docs/Web/HTML/Element/audio"><code>&lt;audio&gt;</code></a> and <a title="Use the HTML <video> element to embed video content in a document." href="/en-US/docs/Web/HTML/Element/video"><code>&lt;video&gt;</code></a>, address of the media resource. The value of this attribute is ignored when the <code>&lt;source&gt;</code> element is placed inside a <a title="The HTML <picture> element is a container used to specify multiple <source> elements for a specific <img> contained in it. The browser will choose the most suitable source according to the current layout of the page (the constraints of the box the image will appear in) and the device it will be displayed on (e.g. a normal or hiDPI device.)" href="/en-US/docs/Web/HTML/Element/picture"><code>&lt;picture&gt;</code></a> element.
 * video - The URL of the video to embed. This is optional; you may instead use the <a title="The HTML <source> element specifies multiple media resources for either the <picture>, the <audio> or the <video> element. It is an empty element. It is commonly used to serve the same media content in multiple formats supported by different browsers." href="/en-US/docs/Web/HTML/Element/source"><code>&lt;source&gt;</code></a> element within the video block to specify the video to embed.
 * audio - The URL of the audio to embed. This is subject to <a href="/en-US/docs/HTTP_access_control">HTTP access controls</a>. This is optional; you may instead use the <a title="The HTML <source> element specifies multiple media resources for either the <picture>, the <audio> or the <video> element. It is an empty element. It is commonly used to serve the same media content in multiple formats supported by different browsers." href="/en-US/docs/Web/HTML/Element/source"><code>&lt;source&gt;</code></a> element within the audio block to specify the audio to embed.
 * img - The image URL. This attribute is mandatory for the <code>&lt;img&gt;</code> element. On browsers supporting <code>srcset</code>, <code>src</code> is treated like a candidate image with a pixel density descriptor <code>1x</code> unless an image with this pixel density descriptor is already defined in <code>srcset,</code> or unless&nbsp;<code>srcset</code> contains '<code>w</code>' descriptors.
 * input - If the value of the <strong>type</strong> attribute is <code>image</code>, this attribute specifies a URI for the location of an image to display on the graphical submit button,&nbsp;otherwise it is ignored.
 * iframe - The URL of the page to embed. Use <a href="/en-US/docs/Web/Security/Same-origin_policy#Inherited_origins">'about:blank'</a>&nbsp;for empty pages that conform to Same-Origin Policy.
 * embed - The URL&nbsp;of the resource being embedded.
 * script - This attribute specifies the <abbr>URI</abbr> of an external script; this can be used as an alternative to embedding a script directly within a document. If a <code>script</code> element has a <code>src</code> attribute specified, it should not have a script embedded inside its tags.
 */
object src extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_src_attr.type]("src", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_src_attr.type]("src", v)
type attrType = _src_attr.type

}

object _src_attr {
@inline implicit def toaudioApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[audio.tag.type]]
@inline implicit def toaudioOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[audio.tag.type]]
             
@inline implicit def toembedApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[embed.tag.type]]
@inline implicit def toembedOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[embed.tag.type]]
             
@inline implicit def toiframeApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[iframe.tag.type]]
@inline implicit def toiframeOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[iframe.tag.type]]
             
@inline implicit def toimgApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[img.tag.type]]
@inline implicit def toimgOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[img.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def toscriptApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[script.tag.type]]
@inline implicit def toscriptOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[script.tag.type]]
             
@inline implicit def tosourceApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[source.tag.type]]
@inline implicit def tosourceOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[source.tag.type]]
             
@inline implicit def totrackApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[track.tag.type]]
@inline implicit def totrackOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[track.tag.type]]
             
@inline implicit def tovideoApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[video.tag.type]]
@inline implicit def tovideoOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[video.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_src_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_src_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
