package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * This integer attribute specifies the start value for numbering the individual list items. Although the ordering type of list elements might be Roman numerals, such as XXXI, or letters, the value of start is always represented as a number. To start numbering elements from the letter "C", use <code>&lt;ol start="3"&gt;</code>. <div class="note"> <strong>Note</strong>: This attribute was deprecated in HTML4, but reintroduced in HTML5.</div>
 */
object start extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_start_attr.type]("start", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_start_attr.type]("start", v)
type attrType = _start_attr.type

}

object _start_attr {
@inline implicit def toolApplied(pair: AttrPair[_start_attr.type]) = pair.asInstanceOf[AttrPair[ol.tag.type]]
@inline implicit def toolOptionalApplied(pair: OptionalAttrPair[_start_attr.type]) = pair.asInstanceOf[OptionalAttrPair[ol.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_start_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_start_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
