package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * Works with the <strong>min</strong> and <strong>max</strong> attributes to limit the increments at which a numeric or date-time value can be set. It can be the string <code>any</code> or a positive floating point number. If this attribute is not set to <code>any</code>, the control accepts only values at multiples of the step value greater than the minimum.
 */
object step extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_step_attr.type]("step", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_step_attr.type]("step", v)
type attrType = _step_attr.type

}

object _step_attr {
@inline implicit def toinputApplied(pair: AttrPair[_step_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_step_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_step_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_step_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
