package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;summary&gt;</code> element</strong> is used as a summary, caption, or legend for the content of a <a title="The HTML <details> element is used as a disclosure widget from which the user can retrieve additional information." href="/en-US/docs/Web/HTML/Element/details"><code>&lt;details&gt;</code></a> element.
 * This attribute defines an alternative text that summarizes the content of the table. Typically, it allows visually impaired people&nbsp;who are browsing the web with&nbsp;a Braille screen, to acquire information about the table. If the information added by&nbsp;this attribute is also&nbsp;useful to people who are not visually impaired, consider using the <a title="The HTML <caption> element represents the title of a table. Though it is always the first descendant of a <table>, its styling, using CSS, may place it elsewhere, relative to the table." href="/en-US/docs/Web/HTML/Element/caption"><code>&lt;caption&gt;</code></a> instead. The summary attribute is not mandatory and may be omitted when a <a title="The HTML <caption> element represents the title of a table. Though it is always the first descendant of a <table>, its styling, using CSS, may place it elsewhere, relative to the table." href="/en-US/docs/Web/HTML/Element/caption"><code>&lt;caption&gt;</code></a> element fulfills its role. <div class="note"> <strong>Usage Note: </strong>Do not use this attribute, as it has been deprecated. Instead, choose one of these methods to add a description of a table:  <ul>   <li>Use&nbsp;prose&nbsp;around&nbsp;the table (this method is less&nbsp;semantic).</li>   <li>Add a description in the table's <a title="The HTML <caption> element represents the title of a table. Though it is always the first descendant of a <table>, its styling, using CSS, may place it elsewhere, relative to the table." href="/en-US/docs/Web/HTML/Element/caption"><code>&lt;caption&gt;</code></a> element.</li>   <li>Add a description in a <a title="The HTML <details> element is used as a disclosure widget from which the user can retrieve additional information." href="/en-US/docs/Web/HTML/Element/details"><code>&lt;details&gt;</code></a> element, inside the table's <a title="The HTML <caption> element represents the title of a table. Though it is always the first descendant of a <table>, its styling, using CSS, may place it elsewhere, relative to the table." href="/en-US/docs/Web/HTML/Element/caption"><code>&lt;caption&gt;</code></a> element.</li>   <li>Include the <a title="The HTML <table> element represents tabular data — that is, information expressed via a two-dimensional data table." href="/en-US/docs/Web/HTML/Element/table"><code>&lt;table&gt;</code></a> element in a <a title="The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit." href="/en-US/docs/Web/HTML/Element/figure"><code>&lt;figure&gt;</code></a> element and add the description in prose next to it.</li>   <li>Include the <a title="The HTML <table> element represents tabular data — that is, information expressed via a two-dimensional data table." href="/en-US/docs/Web/HTML/Element/table"><code>&lt;table&gt;</code></a> element in a <a title="The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit." href="/en-US/docs/Web/HTML/Element/figure"><code>&lt;figure&gt;</code></a> element and add the description in prose inside a <a title="The HTML <figcaption> element represents a caption or a legend associated with a figure or an illustration described by the rest of the data of the <figure> element which is its immediate ancestor." href="/en-US/docs/Web/HTML/Element/figcaption"><code>&lt;figcaption&gt;</code></a> element.</li>   <li>Adjust the table so that a description is not&nbsp;needed (e.g.&nbsp;use&nbsp;<a title="The HTML <th> element defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes." href="/en-US/docs/Web/HTML/Element/th"><code>&lt;th&gt;</code></a> and <a title="The HTML <thead> element defines a set of rows defining the head of the columns of the table." href="/en-US/docs/Web/HTML/Element/thead"><code>&lt;thead&gt;</code></a> elements).</li>  </ul> </div>
 */
object summary extends Tag with Attr {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Element
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("summary", mods)
}
@inline def :=(v: String) = new AttrPair[_summary_attr.type]("summary", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_summary_attr.type]("summary", v)
type attrType = _summary_attr.type

}

object _summary_attr {
@inline implicit def totableApplied(pair: AttrPair[_summary_attr.type]) = pair.asInstanceOf[AttrPair[table.tag.type]]
@inline implicit def totableOptionalApplied(pair: OptionalAttrPair[_summary_attr.type]) = pair.asInstanceOf[OptionalAttrPair[table.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_summary_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_summary_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
