package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * a - Specifies where to display the linked URL. It is a name of, or keyword for, a <em>browsing context</em>: a tab, window, or <code>&lt;iframe&gt;</code>. The following keywords have special meanings: <ul>  <li><code>_self</code>: Load the URL into the same browsing context as the current one. This is the default behavior.</li>  <li><code>_blank</code>: Load the URL into a new browsing context. This is usually a tab, but users can configure browsers to use new windows instead.</li>  <li><code>_parent</code>: Load the URL into the parent browsing context of the current one. If there is no parent, this behaves the same way as <code>_self</code>.</li>  <li><code>_top</code>: Load the URL into the top-level browsing context (that is, the "highest" browsing context that is an ancestor of the current one, and has no parent). If there is no parent,&nbsp;this behaves the same way as <code>_self</code>.</li> </ul> <div class="note">  <p><strong>Note:</strong> When using <code>target</code>, consider adding <code>rel="noopener noreferrer"</code> to avoid exploitation of the <code>window.opener</code> API.</p> </div>
 * base - A name or keyword indicating the default location to display the result when hyperlinks or forms cause navigation, for elements that do not have an explicit target reference. It is a name of, or keyword for, a <em>browsing context</em> (for example: tab, window, or inline frame). The following keywords have special meanings: <ul>  <li><code>_self</code>: Load the result into the same browsing context&nbsp;as the current one. This value is the default if the attribute is not specified.</li>  <li><code>_blank</code>: Load the result into a new unnamed browsing context.</li>  <li><code>_parent</code>: Load the result into the parent browsing context of the current one. If there is no parent, this option behaves the same way as <code>_self</code>.</li>  <li><code>_top</code>: Load the result into the top-level browsing context (that is, the browsing context that is an ancestor of the current one, and has no parent). If there is no parent, this option behaves the same way as <code>_self</code>.</li> </ul>
 * area - This attribute specifies where to display the linked resource. In HTML4, this is the name of, or a keyword for, a frame. In HTML5, it is a name of, or keyword for, a <em>browsing context</em> (for example, tab, window, or inline frame). The following keywords have special meanings: <ul>  <li><code>_self</code>: Load the response into the same HTML4 frame (or HTML5 browsing context) as the current one. This value is the default if the attribute is not specified.</li>  <li><code>_blank</code>: Load the response into a new unnamed HTML4 window or HTML5 browsing context.</li>  <li><code>_parent</code>: Load the response into the HTML4 frameset parent of the current frame or HTML5 parent browsing context of the current one. If there is no parent, this option behaves the same way as <code>_self</code>.</li>  <li><code>_top</code>: In HTML4: Load the response into the full, original window, canceling all other frames. In HTML5: Load the response into the top-level browsing context (that is, the browsing context that is an ancestor of the current one, and has no parent). If there is no parent, this option behaves the same way as <code>_self</code>.</li> </ul> Use this attribute only if the <strong>href</strong> attribute is present.
 * form - A name or keyword indicating where to display the response that is received after submitting the form. In HTML 4, this is the name/keyword for a frame. In HTML5, it is a name/keyword for a <em>browsing context</em> (for example, tab, window, or inline frame). The following keywords have special meanings: <ul>  <li><code>_self</code>: Load the response into the same HTML 4 frame (or HTML5 browsing context) as the current one. This value is the default if the attribute is not specified.</li>  <li><code>_blank</code>: Load the response into a new unnamed HTML 4 window or HTML5 browsing context.</li>  <li><code>_parent</code>: Load the response into the HTML 4 frameset parent of the current frame, or HTML5 parent browsing context of the current one. If there is no parent, this option behaves the same way as <code>_self</code>.</li>  <li><code>_top</code>: HTML 4: Load the response into the full original window, and cancel all other frames. HTML5: Load the response into the top-level browsing context (i.e., the browsing context that is an ancestor of the current one, and has no parent). If there is no parent, this option behaves the same way as <code>_self</code>.</li>  <li><em>iframename</em>: The response is displayed in a named <a title="The HTML <iframe>&nbsp;element&nbsp;represents a nested browsing context, effectively embedding another HTML page into the current page. In HTML 4.01, a document may contain a head and a body or a head and a frameset, but not both a body and a frameset. However, an <iframe> can be used within a normal document body. Each browsing context has its own session history and active document. The browsing context that contains the embedded content is called the parent browsing context. The top-level browsing context (which has no parent) is typically the browser window." href="/en-US/docs/Web/HTML/Element/iframe"><code>&lt;iframe&gt;</code></a>.</li> </ul> <p>HTML5: This value can be overridden by a <code><a href="/en-US/docs/Web/HTML/Element/button#attr-formtarget">formtarget</a></code> attribute on a <a title="The HTML <button> element represents a clickable button." href="/en-US/docs/Web/HTML/Element/button"><code>&lt;button&gt;</code></a> or <a title="The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user." href="/en-US/docs/Web/HTML/Element/input"><code>&lt;input&gt;</code></a> element.</p>
 * link - Defines the frame or window name that has the defined linking relationship or that will show the rendering of any linked resource.
 */
object target extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_target_attr.type]("target", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_target_attr.type]("target", v)
type attrType = _target_attr.type

}

object _target_attr {
@inline implicit def toaApplied(pair: AttrPair[_target_attr.type]) = pair.asInstanceOf[AttrPair[a.tag.type]]
@inline implicit def toaOptionalApplied(pair: OptionalAttrPair[_target_attr.type]) = pair.asInstanceOf[OptionalAttrPair[a.tag.type]]
             
@inline implicit def toareaApplied(pair: AttrPair[_target_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_target_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def tobaseApplied(pair: AttrPair[_target_attr.type]) = pair.asInstanceOf[AttrPair[base.tag.type]]
@inline implicit def tobaseOptionalApplied(pair: OptionalAttrPair[_target_attr.type]) = pair.asInstanceOf[OptionalAttrPair[base.tag.type]]
             
@inline implicit def toformApplied(pair: AttrPair[_target_attr.type]) = pair.asInstanceOf[AttrPair[form.tag.type]]
@inline implicit def toformOptionalApplied(pair: OptionalAttrPair[_target_attr.type]) = pair.asInstanceOf[OptionalAttrPair[form.tag.type]]
             
@inline implicit def tolinkApplied(pair: AttrPair[_target_attr.type]) = pair.asInstanceOf[AttrPair[link.tag.type]]
@inline implicit def tolinkOptionalApplied(pair: OptionalAttrPair[_target_attr.type]) = pair.asInstanceOf[OptionalAttrPair[link.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_target_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_target_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
