package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;tbody&gt;</code> element</strong> groups one or more <a title="The HTML <tr> element specifies that the markup contained inside the <tr> block comprises one row of a table, inside which the <th> and <td> elements create header and data cells, respectively, within the row." href="/en-US/docs/Web/HTML/Element/tr"><code>&lt;tr&gt;</code></a> elements as the body of a <a title="The HTML <table> element represents tabular data — that is, information expressed via a two-dimensional data table." href="/en-US/docs/Web/HTML/Element/table"><code>&lt;table&gt;</code></a> element.
 */
object tbody extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Element
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("tbody", mods)
}


}

object _tbody_attr {

}
