package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;tr&gt;</code> element</strong> defines a row of cells in a table. Those can be a mix of <a title="The HTML <td> element defines a cell of a table that contains data. It participates in the table model." href="/en-US/docs/Web/HTML/Element/td"><code>&lt;td&gt;</code></a> and <a title="The HTML <th> element defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes." href="/en-US/docs/Web/HTML/Element/th"><code>&lt;th&gt;</code></a> elements.
 */
object tr extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.TableRow
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("tr", mods)
}


}

object _tr_attr {

}
