package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;track&gt;</code> element</strong> is used as a child of the media elements <a title="The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element:&nbsp;the browser will choose the most suitable one. It can also be the destination for streamed media, using a MediaStream." href="/en-US/docs/Web/HTML/Element/audio"><code>&lt;audio&gt;</code></a> and <a title="Use the HTML <video> element to embed video content in a document." href="/en-US/docs/Web/HTML/Element/video"><code>&lt;video&gt;</code></a>. It lets you specify timed text tracks (or time-based data), for example to automatically handle subtitles. The tracks are formatted in <a href="/en-US/docs/Web/API/Web_Video_Text_Tracks_Format">WebVTT format</a> (<code>.vtt</code> files) — Web Video Text Tracks.
 */
object track extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Track
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("track", mods)
}


}

object _track_attr {

}
