package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * meter - The current numeric value. This must be between the minimum and maximum values (<code>min</code> attribute and <code>max</code> attribute) if they are specified. If unspecified or malformed, the value is 0. If specified, but not within the range given by the <code>min</code> attribute and <code>max</code> attribute, the value is equal to the nearest end of the range. <div class="note"> <strong>Usage note: </strong>Unless the  <code>value</code> attribute is between  <code>0</code> and  <code>1</code> (inclusive), the  <code>min</code> and  <code>max</code> attributes should define the range so that the  <code>value</code> attribute's value is within it.</div>
 * input - The initial value of the control. This attribute is optional except when the value of the <strong>type</strong> attribute is <code>radio</code> or <code>checkbox</code>.<br> Note that when reloading the page, Gecko and IE <a class="external link-https" href="https://bugzilla.mozilla.org/show_bug.cgi?id=46845#c186">will ignore the value specified in the HTML source</a>, if the value was changed before the reload.
 * li - This integer attribute indicates the current ordinal value of the list item as defined by the <a title="The HTML <ol> element represents an ordered list of items, typically rendered as a numbered list." href="/en-US/docs/Web/HTML/Element/ol"><code>&lt;ol&gt;</code></a> element. The only allowed value for this attribute is a number, even if the list is displayed with Roman numerals or letters. List items that follow this one continue numbering from the value set. The <strong>value</strong> attribute has no meaning for unordered lists (<a title="The HTML <ul> element represents an unordered list of items, typically rendered as a bulleted list." href="/en-US/docs/Web/HTML/Element/ul"><code>&lt;ul&gt;</code></a>) or for menus (<a title="The HTML <menu> element represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked." href="/en-US/docs/Web/HTML/Element/menu"><code>&lt;menu&gt;</code></a>). <div class="note"> <strong>Note</strong>: This attribute was deprecated in HTML4, but reintroduced in HTML5.</div> <div class="note">  <p><strong>Note:</strong> Prior to <span title="(Firefox 9.0 / Thunderbird 9.0 / SeaMonkey 2.6)">Gecko&nbsp;9.0</span>, negative values were incorrectly converted to 0. Starting in <span title="(Firefox 9.0 / Thunderbird 9.0 / SeaMonkey 2.6)">Gecko&nbsp;9.0</span> all integer values are correctly parsed.</p> </div>
 * param - Specifies the value of the parameter.
 * progress - This attribute specifies how much of the task that has been completed. It must be a valid floating point number between 0 and <code>max</code>, or between 0 and 1 if <code>max</code> is omitted. If there is no <code>value</code> attribute, the progress bar is indeterminate; this indicates that an activity is ongoing with no indication of how long it is expected to take.
 * button - The initial value of the button. It defines the value associated with the button which is submitted with the form data. &nbsp;This value is passed to the server in params&nbsp;when the form is submitted.
 * data - This attribute specifies the machine-readable translation of the content of the element.
 * option - The content of this attribute represents the value to be submitted with the form, should this option be selected.&nbsp;If this attribute is omitted, the value is taken from the text content of the option element.
 */
object value extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_value_attr.type]("value", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_value_attr.type]("value", v)
type attrType = _value_attr.type

}

object _value_attr {
@inline implicit def tobuttonApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[button.tag.type]]
@inline implicit def tobuttonOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[button.tag.type]]
             
@inline implicit def todataApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[data.tag.type]]
@inline implicit def todataOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[data.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def toliApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[li.tag.type]]
@inline implicit def toliOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[li.tag.type]]
             
@inline implicit def tometerApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[meter.tag.type]]
@inline implicit def tometerOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meter.tag.type]]
             
@inline implicit def tooptionApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[option.tag.type]]
@inline implicit def tooptionOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[option.tag.type]]
             
@inline implicit def toparamApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[param.tag.type]]
@inline implicit def toparamOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[param.tag.type]]
             
@inline implicit def toprogressApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[progress.tag.type]]
@inline implicit def toprogressOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[progress.tag.type]]
             
@inline implicit def toselectApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[select.tag.type]]
@inline implicit def toselectOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[select.tag.type]]
             
@inline implicit def totextareaApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[textarea.tag.type]]
@inline implicit def totextareaOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[textarea.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_value_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_value_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
