package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * th - This attribute is used to define a recommended cell width. &nbsp;Additional space can be added with the&nbsp;<a href="/en-US/docs/Web/API/HTMLTableElement/cellSpacing">cellspacing</a> and <a href="/en-US/docs/Web/API/HTMLTableElement/cellPadding">cellpadding</a>&nbsp;properties and the width of the <a title="The HTML <col> element defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a <colgroup> element." href="/en-US/docs/Web/HTML/Element/col"><code>&lt;col&gt;</code></a>&nbsp;element can also create extra width.&nbsp;But, if a column's width is too narrow to show a particular cell properly, it will be widened when&nbsp;displayed. <div class="note"> <strong>Usage Note: </strong>Do not use this attribute in the latest standard: use the CSS  <a title="The width property specifies the width of an element. By default, the property defines the width of the content area. If box-sizing is set to border-box, it instead determines the width of the border area." href="/en-US/docs/Web/CSS/width"><code>width</code></a> property instead.</div>
 * object - The width of the display resource, in <a class="external" href="https://drafts.csswg.org/css-values/#px">CSS pixels</a>. &nbsp;-- (Absolute values&nbsp;only. &nbsp;<a class="external" href="https://html.spec.whatwg.org/multipage/embedded-content.html#dimension-attributes">NO&nbsp;percentages</a>)
 * col, colgroup - This attribute specifies a default width for each column in the current column group. In addition to the standard pixel and percentage values, this attribute might take the special form <code>0&#47;</code>, which means that the width of each column in the group should be the minimum width necessary to hold the column's contents. Relative widths such as <code>0.5&#47;</code> also can be used.
 * video - The width of the video's display area, in&nbsp;<a class="external" href="https://drafts.csswg.org/css-values/#px">CSS pixels</a>. &nbsp;-- (Absolute values&nbsp;only. &nbsp;<a class="external" href="https://html.spec.whatwg.org/multipage/embedded-content.html#dimension-attributes">NO&nbsp;percentages</a>)
 * td - This attribute is used to define a recommended cell width. &nbsp;Properties&nbsp;<a href="/en-US/docs/Web/API/HTMLTableElement/cellSpacing">cellspacing</a> and <a href="/en-US/docs/Web/API/HTMLTableElement/cellPadding">cellpadding</a> may add additional space, and element&nbsp;<a title="The HTML <col> element defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a <colgroup> element." href="/en-US/docs/Web/HTML/Element/col"><code>&lt;col&gt;</code></a>&nbsp;width may also have some effect. In general, if a column's width is too narrow to show a particular cell properly, it, and thus the cells in it, may be widened when displayed. <div class="note"> <strong>Note: </strong>Do not use this attribute in the latest standard: instead set the CSS  <a title="The width property specifies the width of an element. By default, the property defines the width of the content area. If box-sizing is set to border-box, it instead determines the width of the border area." href="/en-US/docs/Web/CSS/width"><code>width</code></a> property.</div>
 * iframe - Indicates the width of the frame <span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML/HTML5">HTML5</a></span> in CSS pixels, or <span class="inlineIndicator htmlVer htmlVerInline">HTML 4.01</span> in pixels or as a percentage.
 * canvas - The width of the coordinate space in CSS pixels. Defaults to 300.
 * pre - Contains the <em>preferred</em> count of characters that a line should have. Though technically still implemented, this attribute has no visual effect; to achieve such an effect, use CSS <a title="The width property specifies the width of an element. By default, the property defines the width of the content area. If box-sizing is set to border-box, it instead determines the width of the border area." href="/en-US/docs/Web/CSS/width"><code>width</code></a> instead.
 * hr - Sets the length of the rule on the page through a pixel or percentage value.
 * img - The intrinsic width of the image in pixels.&nbsp;In <span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML">HTML 4</a></span>, either a percentage or pixels were acceptable values. In&nbsp;<span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML/HTML5">HTML5</a></span>, however, only pixels are acceptable.
 * table - This attribute defines the width of the table. The width may be defined by pixels or a percentage value. A percentage value will be defined by the width of the container in which the table is placed. <div class="note"> <strong>Usage Note: </strong>Do not use this attribute, as it has been deprecated. The rules should be defined and styled using  <a href="/en-US/docs/CSS">CSS</a>. Use the  <a title="The width property specifies the width of an element. By default, the property defines the width of the content area. If box-sizing is set to border-box, it instead determines the width of the border area." href="/en-US/docs/Web/CSS/width"><code>width</code></a> property instead.</div>
 * embed - The displayed width of the resource, in <a class="external" href="https://drafts.csswg.org/css-values/#px">CSS pixels</a>. &nbsp;-- (Absolute values&nbsp;only. &nbsp;<a class="external" href="https://html.spec.whatwg.org/multipage/embedded-content.html#dimension-attributes">NO&nbsp;percentages</a>)
 * input - If the value of the <strong>type</strong> attribute is <code>image</code>, this attribute defines the width of the image displayed for the button.
 */
object width extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_width_attr.type]("width", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_width_attr.type]("width", v)
type attrType = _width_attr.type

}

object _width_attr {
@inline implicit def tocanvasApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[canvas.tag.type]]
@inline implicit def tocanvasOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[canvas.tag.type]]
             
@inline implicit def tocolApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[col.tag.type]]
@inline implicit def tocolOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[col.tag.type]]
             
@inline implicit def tocolgroupApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[colgroup.tag.type]]
@inline implicit def tocolgroupOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[colgroup.tag.type]]
             
@inline implicit def toembedApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[embed.tag.type]]
@inline implicit def toembedOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[embed.tag.type]]
             
@inline implicit def tohrApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[hr.tag.type]]
@inline implicit def tohrOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[hr.tag.type]]
             
@inline implicit def toiframeApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[iframe.tag.type]]
@inline implicit def toiframeOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[iframe.tag.type]]
             
@inline implicit def toimgApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[img.tag.type]]
@inline implicit def toimgOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[img.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def toobjectApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[`object`.tag.type]]
@inline implicit def toobjectOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[`object`.tag.type]]
             
@inline implicit def topreApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[pre.tag.type]]
@inline implicit def topreOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[pre.tag.type]]
             
@inline implicit def totableApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[table.tag.type]]
@inline implicit def totableOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[table.tag.type]]
             
@inline implicit def totdApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[td.tag.type]]
@inline implicit def totdOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[td.tag.type]]
             
@inline implicit def tothApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[th.tag.type]]
@inline implicit def tothOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[th.tag.type]]
             
@inline implicit def tovideoApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[video.tag.type]]
@inline implicit def tovideoOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[video.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_width_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_width_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
