package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * textarea - Indicates how the control wraps text. Possible values are: <ul>  <li><code>hard</code>: The browser automatically inserts line breaks (CR+LF) so that each line has no more than the width of the control; the <code>cols</code> attribute must be specified.</li>  <li><code>soft</code>: The browser ensures that all line breaks in the value consist of a CR+LF pair, but does not insert any additional line breaks.</li>  <li><code>off</code>: <span title="This API has not been standardized."><i class="icon-warning-sign"> </i></span> Like <code>soft</code> but changes appearance to <code>white-space: pre</code> so line segments exceeding <code>cols</code> are not wrapped and area becomes horizontally scrollable.</li> </ul> <p>If this attribute is not specified, <code>soft</code> is its default value.</p>
 * pre - Is a <em>hint</em> indicating how the overflow must happen. In modern browser this hint is ignored and no visual effect results in its present; to achieve such an effect, use CSS <a title="The white-space CSS property determines how whitespace inside an element is handled. To make words break within themselves, use overflow-wrap, word-break, or hyphens instead." href="/en-US/docs/Web/CSS/white-space"><code>white-space</code></a> instead.
 */
object wrap extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_wrap_attr.type]("wrap", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_wrap_attr.type]("wrap", v)
type attrType = _wrap_attr.type

}

object _wrap_attr {
@inline implicit def topreApplied(pair: AttrPair[_wrap_attr.type]) = pair.asInstanceOf[AttrPair[pre.tag.type]]
@inline implicit def topreOptionalApplied(pair: OptionalAttrPair[_wrap_attr.type]) = pair.asInstanceOf[OptionalAttrPair[pre.tag.type]]
             
@inline implicit def totextareaApplied(pair: AttrPair[_wrap_attr.type]) = pair.asInstanceOf[AttrPair[textarea.tag.type]]
@inline implicit def totextareaOptionalApplied(pair: OptionalAttrPair[_wrap_attr.type]) = pair.asInstanceOf[OptionalAttrPair[textarea.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_wrap_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_wrap_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
