/*
 * Decompiled with CFR 0.152.
 */
package me.shakiba.jdbi.annotation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnoMapper<C>
implements ResultSetMapper<C> {
    private final Class<C> clazz;
    private final List<Anno> annos;
    private static Logger logger = LoggerFactory.getLogger(AnnoMapper.class);

    public static boolean accept(Class<?> clazz) {
        if (logger.isDebugEnabled()) {
            logger.debug("accept " + clazz);
        }
        return clazz.getAnnotation(Entity.class) != null;
    }

    public static <C> AnnoMapper<C> get(Class<C> clazz) {
        return new AnnoMapper<C>(clazz);
    }

    public AnnoMapper(Class<C> clazz) {
        if (logger.isDebugEnabled()) {
            logger.debug("init " + clazz);
        }
        this.clazz = clazz;
        this.annos = new ArrayList<Anno>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(Column.class) == null) continue;
            this.annos.add(new Anno(field));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (((Method)accessibleObject).getAnnotation(Column.class) == null || ((Method)accessibleObject).getParameterTypes().length != 1) continue;
            this.annos.add(new Anno((Method)accessibleObject));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init " + clazz + "/" + this.annos.size());
        }
    }

    public boolean isEmpty() {
        return this.annos.isEmpty();
    }

    public C map(int i, ResultSet rs, StatementContext ctx) throws SQLException {
        C obj;
        if (logger.isDebugEnabled()) {
            logger.debug("map " + this.clazz);
        }
        try {
            Constructor<C> constructor = this.clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            obj = constructor.newInstance(new Object[0]);
            for (Anno anno : this.annos) {
                anno.apply(obj, rs, ctx);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return obj;
    }

    private static String nameOf(Member member, Column column) {
        String name = column.name();
        if (name == null || name.length() == 0) {
            name = member.getName();
        }
        return name;
    }

    private static Type typeOf(Class<?> type) {
        if (String.class.isAssignableFrom(type)) {
            return Type.String;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return Type.Long;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return Type.Int;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return Type.Double;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Type.Float;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return Type.Boolean;
        }
        if (Date.class.isAssignableFrom(type)) {
            return Type.Date;
        }
        return null;
    }

    private static enum Type {
        String,
        Long,
        Int,
        Double,
        Float,
        Boolean,
        Date;

    }

    private class Anno {
        private Column column;
        private String name;
        private Type type;
        private Field field;
        private Method method;

        public Anno(Field member) {
            this.field = member;
            this.column = member.getAnnotation(Column.class);
            this.name = AnnoMapper.nameOf(member, this.column);
            this.type = AnnoMapper.typeOf(member.getType());
        }

        public Anno(Method member) {
            this.method = member;
            this.column = member.getAnnotation(Column.class);
            this.name = AnnoMapper.nameOf(member, this.column);
            this.type = AnnoMapper.typeOf(member.getParameterTypes()[0]);
        }

        private void apply(C obj, ResultSet rs, StatementContext ctx) throws SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (logger.isDebugEnabled()) {
                logger.debug("apply " + AnnoMapper.this.clazz + "/" + this.name + "/" + (Object)((Object)this.type));
            }
            Object value = this.get(rs, ctx);
            if (logger.isDebugEnabled()) {
                logger.debug("apply " + AnnoMapper.this.clazz + "/" + this.name + "/" + (Object)((Object)this.type) + "/" + value);
            }
            if (value == null) {
                return;
            }
            if (this.method != null) {
                this.method.setAccessible(true);
                this.method.invoke(obj, value);
            }
            if (this.field != null) {
                this.field.setAccessible(true);
                this.field.set(obj, value);
            }
        }

        private Object get(ResultSet rs, StatementContext ctx) throws SQLException {
            switch (this.type) {
                case String: {
                    return rs.getString(this.name);
                }
                case Long: {
                    return rs.getLong(this.name);
                }
                case Int: {
                    return rs.getInt(this.name);
                }
                case Double: {
                    return rs.getDouble(this.name);
                }
                case Float: {
                    return Float.valueOf(rs.getFloat(this.name));
                }
                case Boolean: {
                    return rs.getBoolean(this.name);
                }
                case Date: {
                    return rs.getDate(this.name);
                }
            }
            return null;
        }
    }
}

