/*
 * Decompiled with CFR 0.152.
 */
package me.shakiba.jdbi.annotation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.persistence.Column;
import me.shakiba.jdbi.annotation.AnnoMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnoClass<C> {
    private static final WeakHashMap<Class<?>, AnnoClass<?>> cache = new WeakHashMap();
    private final List<AnnoMember> setters = new ArrayList<AnnoMember>();
    private final List<AnnoMember> getters = new ArrayList<AnnoMember>();
    private static Logger logger = LoggerFactory.getLogger(AnnoClass.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <C> AnnoClass<C> get(Class<C> clazz) {
        AnnoClass<Object> get = null;
        get = cache.get(clazz);
        if (get == null) {
            WeakHashMap<Class<?>, AnnoClass<?>> weakHashMap = cache;
            synchronized (weakHashMap) {
                get = cache.get(clazz);
                if (get == null) {
                    get = new AnnoClass<C>(clazz);
                    cache.put(clazz, get);
                }
            }
        }
        return get;
    }

    private AnnoClass(Class<C> clazz) {
        if (logger.isDebugEnabled()) {
            logger.debug("init " + clazz);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(Column.class) == null) continue;
            this.setters.add(new AnnoMember(clazz, field));
            this.getters.add(new AnnoMember(clazz, field));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (((Method)accessibleObject).getAnnotation(Column.class) == null) continue;
            if (((Method)accessibleObject).getParameterTypes().length == 1) {
                this.setters.add(new AnnoMember(clazz, (Method)accessibleObject));
                continue;
            }
            if (((Method)accessibleObject).getParameterTypes().length != 0) continue;
            this.getters.add(new AnnoMember(clazz, (Method)accessibleObject));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init " + clazz + ": " + this.setters.size() + " setters and " + this.getters.size() + " getters.");
        }
    }

    public List<AnnoMember> setters() {
        return this.setters;
    }

    public List<AnnoMember> getters() {
        return this.getters;
    }
}

