/*
 * Decompiled with CFR 0.152.
 */
package me.shakiba.jdbi.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import javax.persistence.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnoMember {
    private Column column;
    private String name;
    private Type type;
    private Field field;
    private Method method;
    private Class<?> clazz;
    private static Logger logger = LoggerFactory.getLogger(AnnoMember.class);

    public AnnoMember(Class<?> clazz, Field member) {
        this.clazz = clazz;
        this.field = member;
        this.column = member.getAnnotation(Column.class);
        this.name = this.nameOf(member, this.column);
        this.type = AnnoMember.typeOf(member.getType());
    }

    public AnnoMember(Class<?> clazz, Method member) {
        this.clazz = clazz;
        this.method = member;
        this.column = member.getAnnotation(Column.class);
        this.name = this.nameOf(member, this.column);
        this.type = AnnoMember.typeOf(member.getParameterTypes()[0]);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Object read(Object obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.method != null) {
            this.method.setAccessible(true);
            return this.method.invoke(obj, new Object[0]);
        }
        if (this.field != null) {
            this.field.setAccessible(true);
            return this.field.get(obj);
        }
        throw new RuntimeException("Reached unreachable!");
    }

    public void write(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (logger.isDebugEnabled()) {
            logger.debug("write" + this.clazz + "/" + this.name + "/" + (Object)((Object)this.type) + "/" + value);
        }
        if (value == null) {
            return;
        }
        if (this.method != null) {
            this.method.setAccessible(true);
            this.method.invoke(obj, value);
        }
        if (this.field != null) {
            this.field.setAccessible(true);
            this.field.set(obj, value);
        }
    }

    private String nameOf(Field member, Column column) {
        String name = column.name();
        if (name == null || name.length() == 0) {
            name = member.getName();
        }
        return name;
    }

    private String nameOf(Method member, Column column) {
        String name = column.name();
        if (name == null || name.length() == 0) {
            name = member.getName();
        }
        return name;
    }

    private static Type typeOf(Class<?> type) {
        if (String.class.isAssignableFrom(type)) {
            return Type.String;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return Type.Long;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return Type.Int;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return Type.Double;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Type.Float;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return Type.Boolean;
        }
        if (Date.class.isAssignableFrom(type)) {
            return Type.Date;
        }
        return Type.Other;
    }

    static enum Type {
        String,
        Long,
        Int,
        Double,
        Float,
        Boolean,
        Date,
        Other;

    }
}

