/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser;

import java.util.Set;
import me.snowdrop.licenses.sanitiser.LicenseSanitiser;
import me.snowdrop.licenses.sanitiser.provider.ExternalLicenseProvider;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseElement;

public class LicenseServiceSanitiser
implements LicenseSanitiser {
    private final LicenseSanitiser next;
    private final ExternalLicenseProvider provider;

    public LicenseServiceSanitiser(String licenseServiceUrl, LicenseSanitiser next) {
        this.next = next;
        this.provider = new ExternalLicenseProvider(licenseServiceUrl);
    }

    @Override
    public DependencyElement fix(DependencyElement dependencyElement) {
        Set<LicenseElement> licenses = this.provider.getLicenses(dependencyElement.toGavString());
        if (!licenses.isEmpty()) {
            return new DependencyElement(dependencyElement, licenses);
        }
        return this.next.fix(dependencyElement);
    }
}

