/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.snowdrop.licenses.maven.MavenProjectFactory;
import me.snowdrop.licenses.sanitiser.LicenseSanitiser;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseElement;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSanitiser
implements LicenseSanitiser {
    private final Logger logger = LoggerFactory.getLogger(MavenSanitiser.class);
    private final MavenProjectFactory mavenProjectFactory;
    private final LicenseSanitiser next;

    public MavenSanitiser(MavenProjectFactory mavenProjectFactory, LicenseSanitiser next) {
        this.mavenProjectFactory = mavenProjectFactory;
        this.next = next;
    }

    @Override
    public DependencyElement fix(DependencyElement dependencyElement) {
        if (dependencyElement.getLicenses().size() > 0) {
            return this.next.fix(dependencyElement);
        }
        return this.next.fix(new DependencyElement(dependencyElement, this.getMavenProjectLicenses(dependencyElement)));
    }

    private Set<LicenseElement> getMavenProjectLicenses(DependencyElement dependencyElement) {
        HashSet<LicenseElement> licenses = new HashSet<LicenseElement>();
        Optional<MavenProject> mavenProject = this.mavenProjectFactory.getMavenProject(dependencyElement.getArtifact(), false);
        if (mavenProject.isPresent()) {
            for (License license : mavenProject.get().getLicenses()) {
                licenses.add(new LicenseElement(license));
            }
        } else {
            this.logger.warn("Could not get maven project for {}", (Object)dependencyElement);
        }
        return licenses;
    }
}

