/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;

public interface JsonUtils {
    public static <T> Set<T> loadJsonToSet(String resourceLocation, Function<JsonObject, T> mapper) {
        Set set;
        block8: {
            InputStream fileInputStream = JsonUtils.getInputStream(resourceLocation);
            try {
                set = Json.createReader((InputStream)fileInputStream).readArray().stream().map(JsonValue::asJsonObject).map(mapper).collect(Collectors.toSet());
                if (fileInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read the resource: " + resourceLocation, e);
                }
            }
            fileInputStream.close();
        }
        return set;
    }

    public static InputStream getInputStream(String resourceLocation) throws IOException {
        Path path = Paths.get(resourceLocation, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        return JsonUtils.class.getClassLoader().getResourceAsStream(resourceLocation);
    }
}

