/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import me.snowdrop.licenses.xml.LicenseElement;
import org.apache.maven.artifact.Artifact;

@XmlRootElement(name="dependency")
@XmlType(propOrder={"groupId", "artifactId", "version", "licenses"})
public class DependencyElement {
    private String groupId;
    private String artifactId;
    private String version;
    private Set<LicenseElement> licenses = new HashSet<LicenseElement>();
    private Artifact artifact;

    public DependencyElement() {
    }

    public DependencyElement(Artifact artifact) {
        this.groupId = artifact.getGroupId();
        this.artifactId = artifact.getArtifactId();
        this.version = artifact.getVersion();
        this.artifact = artifact;
    }

    public DependencyElement(DependencyElement dependencyElement) {
        this(dependencyElement.getGroupId(), dependencyElement.getArtifactId(), dependencyElement.getVersion(), dependencyElement.getLicenses());
    }

    public DependencyElement(JsonObject dependencyElementJson) {
        this.groupId = dependencyElementJson.getString("groupId");
        Objects.requireNonNull(this.groupId, "groupId cannot be null");
        this.artifactId = dependencyElementJson.getString("artifactId");
        Objects.requireNonNull(this.artifactId, "artifactId cannot be null");
        this.version = dependencyElementJson.getString("version");
        Objects.requireNonNull(this.version, "version cannot be null");
        this.licenses = dependencyElementJson.getJsonArray("licenses").getValuesAs(JsonObject.class).stream().map(LicenseElement::new).collect(Collectors.toSet());
    }

    public DependencyElement(String groupId, String artifactId, String version, Set<LicenseElement> licenses) {
        Objects.requireNonNull(groupId, "groupId cannot be null");
        Objects.requireNonNull(artifactId, "artifactId cannot be null");
        Objects.requireNonNull(version, "version cannot be null");
        Objects.requireNonNull(licenses, "licenses set cannot be null");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.licenses = new HashSet<LicenseElement>(licenses.size());
        licenses.parallelStream().map(LicenseElement::new).forEach(this.licenses::add);
    }

    public DependencyElement(DependencyElement dependencyElement, Set<LicenseElement> licenses) {
        this(dependencyElement.groupId, dependencyElement.artifactId, dependencyElement.version, licenses);
    }

    public String getGroupId() {
        return this.groupId;
    }

    @XmlElement
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @XmlElement
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @XmlElement
    public void setVersion(String version) {
        this.version = version;
    }

    public Set<LicenseElement> getLicenses() {
        return this.licenses;
    }

    @XmlElement(name="license")
    @XmlElementWrapper
    public void setLicenses(Set<LicenseElement> licenses) {
        this.licenses = Collections.unmodifiableSet(licenses);
    }

    public String toString() {
        return String.format("%s{groupId='%s', artifactId='%s', version='%s', licenses=%s}", DependencyElement.class.getSimpleName(), this.groupId, this.artifactId, this.version, this.licenses);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyElement that = (DependencyElement)o;
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toGavString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }

    @XmlTransient
    public Artifact getArtifact() {
        return this.artifact;
    }
}

