/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.lookup;

import com.neovisionaries.i18n.CountryCode;
import me.tobiadeyinka.itunessearch.exceptions.NoMatchFoundException;
import me.tobiadeyinka.itunessearch.lookup.Lookup;
import org.json.JSONObject;

public class BookLookup
extends Lookup {
    public static JSONObject getBookById(long id) throws NoMatchFoundException {
        return BookLookup.getById(id);
    }

    public static JSONObject topFree() {
        return BookLookup.topFree(100);
    }

    public static JSONObject topFree(int limit) {
        return BookLookup.queryBookList(BookList.TOP_FREE, DEFAULT_COUNTRY, limit);
    }

    public static JSONObject topFree(CountryCode countryCode) {
        return BookLookup.queryBookList(BookList.TOP_FREE, countryCode, 100);
    }

    public static JSONObject topFree(CountryCode countryCode, int limit) {
        return BookLookup.queryBookList(BookList.TOP_FREE, countryCode, limit);
    }

    public static JSONObject topPaid() {
        return BookLookup.topPaid(100);
    }

    public static JSONObject topPaid(int limit) {
        return BookLookup.queryBookList(BookList.TOP_PAID, DEFAULT_COUNTRY, limit);
    }

    public static JSONObject topPaid(CountryCode countryCode) {
        return BookLookup.queryBookList(BookList.TOP_PAID, countryCode, 100);
    }

    public static JSONObject topPaid(CountryCode countryCode, int limit) {
        return BookLookup.queryBookList(BookList.TOP_PAID, countryCode, limit);
    }

    private static JSONObject queryBookList(BookList list, CountryCode countryCode, int limit) {
        return BookLookup.executeQuery(String.format("https://rss.itunes.apple.com/api/v1/%s/books/%s/all/%s/explicit.json", countryCode.getAlpha2(), list.urlKey, limit));
    }

    private static enum BookList {
        TOP_FREE("top-free"),
        TOP_PAID("top-paid");

        String urlKey;

        private BookList(String urlKey) {
            this.urlKey = urlKey;
        }
    }
}

