/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.AudioBookAttribute;
import me.tobiadeyinka.itunessearch.entities.AudioBookSearchReturnType;
import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.search.Search;

public class AudioBookSearch
extends Search<AudioBookSearch> {
    private AudioBookAttribute attribute = AudioBookAttribute.ALL;
    private AudioBookSearchReturnType returnType = AudioBookSearchReturnType.AUDIO_BOOK;

    public AudioBookSearch() {
        super(ItunesMedia.AUDIO_BOOK);
    }

    public AudioBookSearch inAttribute(AudioBookAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public AudioBookSearch andReturn(AudioBookSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public AudioBookAttribute getAttribute() {
        return this.attribute;
    }

    public AudioBookSearchReturnType getReturnType() {
        return this.returnType;
    }
}

