/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.EBookAttribute;
import me.tobiadeyinka.itunessearch.entities.EBookSearchReturnType;
import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.search.Search;

public class EBookSearch
extends Search<EBookSearch> {
    private EBookAttribute attribute = EBookAttribute.ALL;
    private EBookSearchReturnType returnType = EBookSearchReturnType.DEFAULT;

    public EBookSearch() {
        super(ItunesMedia.EBOOK);
    }

    public EBookSearch inAttribute(EBookAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public EBookSearch andReturn(EBookSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public EBookAttribute getAttribute() {
        return this.attribute;
    }

    public EBookSearchReturnType getReturnType() {
        return this.returnType;
    }
}

