/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.entities.MovieAttribute;
import me.tobiadeyinka.itunessearch.entities.MovieSearchReturnType;
import me.tobiadeyinka.itunessearch.search.Search;

public class MovieSearch
extends Search<MovieSearch> {
    private MovieAttribute attribute = MovieAttribute.ALL;
    private MovieSearchReturnType returnType = MovieSearchReturnType.MOVIE;

    public MovieSearch() {
        super(ItunesMedia.MOVIE);
    }

    public MovieSearch inAttribute(MovieAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public MovieSearch andReturn(MovieSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public MovieAttribute getAttribute() {
        return this.attribute;
    }

    public MovieSearchReturnType getReturnType() {
        return this.returnType;
    }
}

