/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.entities.MusicAttribute;
import me.tobiadeyinka.itunessearch.entities.MusicSearchReturnType;
import me.tobiadeyinka.itunessearch.search.Search;

public class MusicSearch
extends Search<MusicSearch> {
    private MusicAttribute attribute = MusicAttribute.ALL;
    private MusicSearchReturnType returnType = MusicSearchReturnType.DEFAULT;

    public MusicSearch() {
        super(ItunesMedia.MUSIC);
    }

    public MusicSearch inAttribute(MusicAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public MusicSearch andReturn(MusicSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public MusicAttribute getAttribute() {
        return this.attribute;
    }

    public MusicSearchReturnType getReturnType() {
        return this.returnType;
    }
}

