/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.entities.PodcastAttribute;
import me.tobiadeyinka.itunessearch.entities.PodcastSearchReturnType;
import me.tobiadeyinka.itunessearch.search.Search;

public class PodcastSearch
extends Search<PodcastSearch> {
    private PodcastAttribute attribute = PodcastAttribute.ALL;
    private PodcastSearchReturnType returnType = PodcastSearchReturnType.PODCAST;

    public PodcastSearch() {
        super(ItunesMedia.PODCAST);
    }

    public PodcastSearch inAttribute(PodcastAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public PodcastSearch andReturn(PodcastSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public PodcastAttribute getAttribute() {
        return this.attribute;
    }

    public PodcastSearchReturnType getReturnType() {
        return this.returnType;
    }
}

