/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import com.neovisionaries.i18n.CountryCode;
import java.net.MalformedURLException;
import java.net.URL;
import me.tobiadeyinka.itunessearch.entities.ItunesApiVersion;
import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.entities.ReturnLanguage;
import me.tobiadeyinka.itunessearch.exceptions.InvalidParameterException;
import me.tobiadeyinka.itunessearch.exceptions.MissingRequiredParameterException;
import me.tobiadeyinka.itunessearch.exceptions.SearchURLConstructionFailure;
import me.tobiadeyinka.itunessearch.search.SearchManager;
import org.json.JSONObject;

abstract class Search<T> {
    protected String searchTerm;
    protected final ItunesMedia media;
    protected int limit = 50;
    protected int apiVersion = 2;
    protected boolean allowExplicit = true;
    protected CountryCode countryCode = CountryCode.US;
    protected ReturnLanguage returnLanguage = ReturnLanguage.ENGLISH;
    protected URL searchUrl;

    protected Search(ItunesMedia media) {
        this.media = media;
    }

    public T with(String searchTerm) {
        this.searchTerm = searchTerm;
        return (T)this;
    }

    public T withLimit(int limit) {
        this.limit = limit;
        return (T)this;
    }

    public T withApiVersion(ItunesApiVersion apiVersion) {
        this.apiVersion = apiVersion.getVersionNumber();
        return (T)this;
    }

    public T allowExplicit(boolean allowExplicit) {
        this.allowExplicit = allowExplicit;
        return (T)this;
    }

    public T withReturnLanguage(ReturnLanguage returnLanguage) {
        this.returnLanguage = returnLanguage;
        return (T)this;
    }

    public T inCountry(CountryCode countryCode) {
        this.countryCode = countryCode;
        return (T)this;
    }

    protected void runPreExecutionChecks() {
        if (this.searchTerm == null || this.searchTerm.isEmpty()) {
            throw new MissingRequiredParameterException("Search execution failed: missing search term parameter");
        }
        if (this.apiVersion < 1 || this.apiVersion > 2) {
            throw new InvalidParameterException("Search execution failed: invalid api version code");
        }
    }

    public JSONObject execute() {
        URL url;
        this.runPreExecutionChecks();
        String urlString = this.constructUrlString();
        this.searchUrl = url = this.createUrlObject(urlString);
        return new SearchManager().executeSearch(url);
    }

    private URL createUrlObject(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new SearchURLConstructionFailure("Error during search url construction: " + e.getMessage());
        }
    }

    protected abstract String constructUrlString();

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public ItunesMedia getMedia() {
        return this.media;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public boolean explicitAllowed() {
        return this.allowExplicit;
    }

    public CountryCode getCountryCode() {
        return this.countryCode;
    }

    public ReturnLanguage getReturnLanguage() {
        return this.returnLanguage;
    }

    public URL getSearchUrl() {
        return this.searchUrl;
    }
}

