/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.entities.ShortFilmAttribute;
import me.tobiadeyinka.itunessearch.entities.ShortFilmSearchReturnType;
import me.tobiadeyinka.itunessearch.search.Search;

public class ShortFilmSearch
extends Search<ShortFilmSearch> {
    private ShortFilmAttribute attribute = ShortFilmAttribute.ALL;
    private ShortFilmSearchReturnType returnType = ShortFilmSearchReturnType.SHORT_FILM;

    public ShortFilmSearch() {
        super(ItunesMedia.SHORT_FILM);
    }

    public ShortFilmSearch inAttribute(ShortFilmAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public ShortFilmSearch andReturn(ShortFilmSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public ShortFilmAttribute getAttribute() {
        return this.attribute;
    }

    public ShortFilmSearchReturnType getReturnType() {
        return this.returnType;
    }
}

