/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.entities.TvShowAttribute;
import me.tobiadeyinka.itunessearch.entities.TvShowSearchReturnType;
import me.tobiadeyinka.itunessearch.search.Search;

public class TvShowSearch
extends Search<TvShowSearch> {
    private TvShowAttribute attribute = TvShowAttribute.ALL;
    private TvShowSearchReturnType returnType = TvShowSearchReturnType.DEFAULT;

    public TvShowSearch() {
        super(ItunesMedia.TV_SHOW);
    }

    public TvShowSearch inAttribute(TvShowAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public TvShowSearch andReturn(TvShowSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public TvShowAttribute getAttribute() {
        return this.attribute;
    }

    public TvShowSearchReturnType getReturnType() {
        return this.returnType;
    }
}

